float4x4 WVP : WORLDVIEWPROJECTION;
float4x4 World : WORLD;

float4 Kolor : COLOR = float4(1,1,0,1);
bool MapujKolorWerteksu = false;

bool OswietleniePerPixel = true; 

float4 Ce : COLOR = float4(0,0,0,1);
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.5,0.5,0.5,1);
float4 Cs : COLOR = float4(1,1,1,1);

float4 Wa = float4(1,1,1,1);
float4 Wd = float4(1,1,1,1);
float4 Ws = float4(1,1,1,1);
float ns = 10;

float3 PozycjaZrodlaSwiatla = float3(1,1,1);
float3 PolozenieKamery : CAMERAPOSITION = float3(0,0,1);

struct Dane_PozycjaNormalnaWspTeksturowania
{
	float4 Polozenie : POSITION0;
	float3 Normalna : NORMAL0;
	float2 WspTeksturowania : TEXCOORD0;
};

struct Dane_PozycjaKolor
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
};

struct Dane_PozycjaKolorNR
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
	float3 N : TEXCOORD1;
	float3 R : TEXCOORD2;
};

float4 ObliczKolor(float4 kolor :COLOR,float3 N,float3 R)
{
	float3 odleglosc=PozycjaZrodlaSwiatla-R;
	float3 L=normalize(odleglosc);
	float dotLN=saturate(dot(L,N));	
	float3 O = 2*dotLN*N-L;
	float3 V = normalize(PolozenieKamery-R);
	float dotOVn = saturate(pow(saturate(dot(O,V)),ns));

	//do poprawy
	float4 _Ce=Ce;
	float4 _Ca=Ca;
	float4 _Cd=Cd;
	if(MapujKolorWerteksu)
	{
		_Ce=kolor;
		_Ca=kolor;
		_Cd=kolor;
	}

	float4 Kolor=saturate(_Ce);
	Kolor+=saturate(Wa*_Ca);
	Kolor+=saturate(Wd*_Cd*dotLN);
	Kolor+=saturate(Ws*Cs*dotOVn);
	Kolor=saturate(Kolor);
	return Kolor;
}

//Dane_PozycjaKolor VS(float4 Polozenie : POSITION0)
//Dane_PozycjaKolor VS(Dane_PozycjaNormalnaWspTeksturowania input)
Dane_PozycjaKolorNR VS(Dane_PozycjaNormalnaWspTeksturowania input)
{
	//Dane_PozycjaKolor output;
	//output.Polozenie=mul(input.Polozenie,WVP);
	//output.Kolor.rgb=abs(input.Normalna);
	//output.Kolor.a=1;

	float3 R=mul(input.Polozenie,World).xyz;
	float3 N=mul(input.Normalna,World);

    Dane_PozycjaKolorNR output;
	output.Polozenie=mul(input.Polozenie,WVP);
	output.Kolor=(!OswietleniePerPixel)?ObliczKolor(Kolor,N,R):Kolor;
	output.N=N;
	output.R=R;
	return output;
}

//float4 PS(Dane_PozycjaKolor input) : COLOR0
float4 PS(Dane_PozycjaKolorNR input) : COLOR0
{
	//return input.Kolor;
	return OswietleniePerPixel?ObliczKolor(input.Kolor,input.N,input.R):input.Kolor;
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}